<?php

/*
ini_set('xdebug.var_display_max_depth','10');
ini_set('display_errors','1');
ini_set('display_startup_errors','1');
error_reporting (E_ALL);
*/

  require("myumbc_xml.php");
  $group = "doit";
  
  if (isset($_GET["id"])) {
    $event = parse_xml($group, "event_" . $_GET["id"], "");
  } else {
    $events = parse_xml($group, "events", "?page=1&page_size=5&mode=recent");
  }
?>

<html>

<head>
  <title>events Page</title>
</head>

<body>
<?php if (isset($event)) { ?>
  <a href="?">Back</a>
  <div id="event">
    <h3><?= $event["title"] ?></h3>
    <p>Tagline: <?= $event["tagline"] ?></p>
    <p>Posted At: <?= $event["posted_at"] ?></p>
    <p>Edited At: <?= $event["edited_at"] ?></p>
    <p>Summary: <?= $event["summary"] ?></p>
    <p>All Day: <?= $event["allday"] ?></p>
    <p>Start: <?= $event["start_date"] ?></p>
    <p>End: <?= $event["end_date"] ?></p>
    <p>Location: <?= $event["location"]["name"] ?></p>
    <p style="padding-left: 12px;">Latitude: <?= $event["location"]["latitude"] ?></p>
    <p style="padding-left: 12px;">Longitude: <?= $event["location"]["longitude"] ?></p>
    <p>Attendee Count: <?= $event["attendee_count"] ?></p>
    <p>Attendee Max: <?= $event["attendee_max"] ?></p>
    <p>Body: <?= $event["body"] ?></p>
    <?php if (isset($event["thumbnail"]["large"])) { ?>
      <p>Thumbnail: <img src=<?= $event["thumbnail"]["large"] ?> /> </p>
    <?php } ?>
    <p>Group: <a href=<?= $event["group_url"] ?>><?= $event["group"] ?></a></p>
    <p>Sponsor: <?= $event["sponsor"] ?></p>
    <p>Website: <?= $event["website"] ?></p>
    <?php if (isset($new_item["attachment_url"])) { ?>
      <p>Attachment Kind: <?= $event["attachment_kind"] ?></p>
      <p>Attachment URL: <a href="<?= $event["attachment_url"] ?>">URL</a></p>
    <?php } ?>
    <?php if (isset($event["tags"])) { ?>
      <p>Tags:</p>
      <ul>
        <?php foreach ($event["tags"] as $tag) { ?>
          <li><?= $tag ?></li>
        <?php } ?>
      </ul>
    <?php } ?>
    <?php if (isset($event["audiences"])) { ?>
      <p>Audiences:</p>
      <ul>
        <?php foreach ($event["audiences"] as $audience) { ?>
          <li><?= $audience ?></li>
        <?php } ?>
      </ul>
    <?php } ?>
    <?php if (isset($event["topics"])) { ?>
      <p>Topics:</p>
      <ul>
        <?php foreach ($event["topics"] as $topic) { ?>
          <li><?= $topic ?></li>
        <?php } ?>
      </ul>
    <?php } ?>
    <p>Paw Count: <?= $event["paw_count"] ?></p>
    <p>Comment Count: <?= $event["comment_count"] ?></p>
  </div>
<?php } else if ($events) { ?>
  <div id="events">
    <h3>Recent events</h3>
    <ul>
    <?php while(list($key,$val) = each($events)): ?>
      <li class='item-<?= $key ?>'>
        <div class="title"><a href="?id=<?= $events[$key]["id"] ?>"><?= $events[$key]["title"] ?></a></div>
        <div class="title">View in myUMBC: <a href="http://my.umbc.edu/groups/<?= $group ?>/events/<?= $events[$key]["id"] ?>">my.umbc.edu/groups/<?= $group ?>/events/<?= $events[$key]["id"] ?></a></div>
      </li>
    <?php endwhile; ?>
    </ul>
  </div>
<?php } else { ?>
<!-- Content when no events is being pulled through myUMBC -->
<?php } ?>


</body>

</html>